<?php

namespace App\Console\Commands;

use App\EmailMessage;
use App\Mail\UserRegistered;
use Illuminate\Console\Command;
use App\Exports\MailMessageExport;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;

require_once( app_path() . '/simple_html_dom.php');

class ReadEmailCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:read';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'read email from inbox';

    protected $emailMessage;
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(EmailMessage $emailMessage)
    {
        parent::__construct();
        $this->emailMessage = $emailMessage;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
    
        
        ini_set('memory_limit', '-1');
        
        try{
            $client = \Webklex\IMAP\Facades\Client::account('default');

            //Connect to the IMAP Server
            $client->connect();
    
            //Get all Mailboxes
            /** @var \Webklex\PHPIMAP\Support\FolderCollection $folders */
            $folders = $client->getFolders();
    
            $form_field_headers = [
                'Email',
                'First name',
                'Last name',
                'Position',
                'Company',
                'Address',
                'Mobile'
            ];
    
            $files_to_upload = [];
    
            //Loop through every Mailbox
    
            // there should be only one file per mail ( entry )
            // prepare the files and move to storage
            // then send to sftp at once per iteration
            
            /** @var \Webklex\PHPIMAP\Folder $folder */
            foreach($folders as $folder){
    
                //Get all Messages of the current Mailbox $folder
                /** @var \Webklex\PHPIMAP\Support\MessageCollection $messages */
    
                // can also get from a given date
    
                $messages = $folder->messages()->all()->get();
                
                /** @var \Webklex\PHPIMAP\Message $message */
                
                foreach($messages as $message){
                    
                    $subject = $message->getSubject();
                    $body = $message->getHTMLBody();
                    $message_id = $message->getMessageId()->toString();
                    $date_created = $message->getDate()->toString();
                    
    
                    // check if already exists
                    if($this->emailMessage->where('message_id', $message_id)->count()){
                        continue;
                    }
    
                    $form_data = [];
                    if($body && $subject == 'registration'){
    
                        // insert into database if not already exists
                        // how to know if it exists, using the subject and date created ?
    
                        $html = str_get_html($body);
                        foreach($html->find('table[class="ff_all_data"] td') as $key => $value) {
                            if(strlen($value->plaintext) >= 0){
                                
                                //$this->info("Key : " . $key . " : " . $value->plaintext);
    
                                if($key == 0) {$form_data['email'] = $value->plaintext;}
                                if($key == 1) {$form_data['first_name'] = $value->plaintext;}
                                if($key == 2) {$form_data['last_name'] = $value->plaintext;}
                                if($key == 3) {$form_data['position'] = $value->plaintext;}
                                if($key == 4) {$form_data['company'] = $value->plaintext;}
                                if($key == 5) {$form_data['address'] = $value->plaintext;}
                                if($key == 6) {$form_data['mobile'] = $value->plaintext;}
                                if($key == 7) {$form_data['interest_event'] = $value->plaintext;}
                                if($key == 8) {$form_data['management_event'] = $value->plaintext;}
                                if($key == 9) {$form_data['role'] = $value->plaintext;}
                                if($key == 10) {$form_data['visit'] = $value->plaintext;}
                                if($key == 11) {$form_data['average_quantity_of_giveways_required'] = $value->plaintext;}
                                if($key == 12) {$form_data['found_the_event'] = $value->plaintext;}
                                if($key == 13) {$form_data['attendance_of_the_event'] = $value->plaintext;}
                            }
                        }
    
                        // grab the ID
                        foreach($html->find('p') as $key => $value) {
                            if(strlen($value->plaintext) >= 0){       
                                //$this->info("Key : " . $key . " : " . $value->plaintext);
                                if($key == 1){
                                    $form_data['entry_id'] = $value->plaintext;
                                }
                            }
                        }
    
    
                        //dump($form_data); continue;
                        
                        $file_name = $form_data['entry_id'] . '-' . str_replace(' ','_',trim($form_data['first_name']))  . '.csv';
                        Excel::store(new MailMessageExport([$form_data]), $file_name);
                        $files_to_upload[] = $file_name;
    
                        // store record in database
                        $this->emailMessage->create([
                            'subject' => $subject,
                            'body' => $body,
                            'message_id' => $message_id,
                            'date_created' => $date_created,
                            'form_data' => json_encode($form_data),
                            'csv_file_name' => $file_name
                        ]);
    
                        // send the email to the user
                        
                        // $qr_code = 
                        // 'First Name: ' . $form_data['first_name'] .  '|' . 
                        // 'Last Name: ' . $form_data['last_name'] .  '|' . 
                        // 'Company: ' . $form_data['company'] .  '|' .
                        // 'Designation: ' . $form_data['position'] .  '|' .
                        // 'Contact No: ' . $form_data['mobile'] .  '|' .
                        // 'Email: ' . $form_data['email'] . '|' . 
                        // 'ID: ' . $form_data['entry_id'];
                        
                        
                        $count_id = strlen($form_data['entry_id']) + 3;
                        $f_id = "";
                        
                        for($i = 9; $i >= $count_id;$count_id++){
                            $f_id .= "0";
                        }
                        
                        $id_format = "ONL".$f_id.$form_data['entry_id'];
                        
                        
                        $qr_code = 
                        $id_format.  '|' .
                        $form_data['first_name'] . " ".
                        $form_data['last_name'] .  '|' . 
                        $form_data['company'] .  '|' .
                        $form_data['position'] .  '|' .
                        $form_data['mobile'] .  '|' .
                        $form_data['email'];
                        
                        $image = \QrCode::format('png')->size(350)->generate($qr_code);
                        $output_file = '/qr-code/img-' . $form_data['entry_id'] . '.png';
                        Storage::disk('local')->put($output_file, $image);
                        
                        ini_set('memory_limit', '-1');
                        $form_data['output_file'] = $output_file;
                        Mail::to($form_data['email'])->send(new UserRegistered($form_data));
                        
    
                        // ftp
                        Storage::disk('ftp')->put($file_name, file_get_contents(storage_path('app') . '/' . $file_name));
    
                        $this->info('Processed email ' . $message_id . ', email with QR code sent to ' . $form_data['email']);
    
                    }
                    
                    
                } // messages
    
            } // end folder 
        }
        catch(Exception $e){ \Log::info($e);}
       
    }
}
