<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserRegistered extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        try{
            //\Log::info('Test Sent');
            //ini_set('memory_limit', '-1');
            return $this->subject('QR code from ' . config('app.name'))
            ->view('emails.email-with-qr')
            ->attach(storage_path('app') . '/' . $this->data['output_file'])
            ->with(get_defined_vars());
        }
        catch(\Exception $e){
            \Log::info($e->getMessage());
        }
        
    }
}
